/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class EmbeddedObjectAttachAgent extends AgentBase {

	// Konstante FILE bitte bei Bedarf anpassen.
	private static final String FILE = "C:/temp/worksheet.xls";

	public void NotesMain() {
		Document doc = null;
		Database db = null; EmbeddedObject eo = null;
		RichTextItem rt = null;
		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			db = agentContext.getCurrentDatabase();
			doc = agentContext.getDocumentContext();
			rt = (RichTextItem) doc.getFirstItem("F_richText");
			rt.embedObject(EmbeddedObject.EMBED_OBJECT,"",FILE,"Report");
			doc.save(true,false);
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rt != null) {rt.recycle();}
				if (eo != null) {eo.recycle();}
				if (doc != null) {doc.recycle();}
				if (db != null) {db.recycle();}
			} catch (NotesException e1) {
				e1.printStackTrace();
			}
		}
	}
}
